/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.commands.exposure;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.clientbound.CaptureStartDebugRGBS2CP;
import io.github.mortuusars.exposure.network.packet.clientbound.ClearRenderingCacheS2CP;
import io.github.mortuusars.exposure.util.PointOfView;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.camera.CameraInHand;
import io.github.mortuusars.exposure.world.camera.ColorChannel;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.capture.CaptureProperties;
import io.github.mortuusars.exposure.world.camera.capture.CaptureType;
import io.github.mortuusars.exposure.world.camera.frame.EntitiesInFrame;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.camera.frame.Photographer;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.ChromaticSheetItem;
import io.github.mortuusars.exposure.world.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.world.item.FilmItem;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class DebugCommand {
    public static LiteralArgumentBuilder<class_2168> get() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"clear_rendering_cache").executes(DebugCommand::clearRenderingCache))).then(class_2170.method_9247((String)"highlight_entities_in_frame").executes(DebugCommand::highlightEntitiesInFrame))).then(class_2170.method_9247((String)"expose_rgb").executes(DebugCommand::exposeRGB))).then(class_2170.method_9247((String)"chromatic_from_last_three_exposures").executes(DebugCommand::chromaticFromLastThreeExposures))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"develop_film_in_hand").executes(context -> DebugCommand.developFilmInHand((CommandContext<class_2168>)context, true))).then(class_2170.method_9247((String)"keep_original").executes(context -> DebugCommand.developFilmInHand((CommandContext<class_2168>)context, false))));
    }

    private static int clearRenderingCache(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 stack = (class_2168)context.getSource();
        class_3222 player = stack.method_9207();
        Packets.sendToClient(ClearRenderingCacheS2CP.INSTANCE, player);
        return 0;
    }

    private static int highlightEntitiesInFrame(CommandContext<class_2168> context) {
        ExposureServer.debugHighlightEntitiesInFrame = !ExposureServer.debugHighlightEntitiesInFrame;
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43471((String)("system.exposure.debug.highlight_entities_in_frame." + (ExposureServer.debugHighlightEntitiesInFrame ? "on" : "off"))).method_27692(class_124.field_1061));
        return 0;
    }

    private static int exposeRGB(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 stack = (class_2168)context.getSource();
        class_3222 player = stack.method_9207();
        @Nullable CameraInHand camera = CameraInHand.find((CameraHolder)player);
        if (camera == null) {
            camera = new CameraInHand((CameraHolder)player, new CameraId(class_156.field_25140), class_1268.field_5808);
        }
        ArrayList<CaptureProperties> properties = new ArrayList<CaptureProperties>();
        for (int i = 0; i < 3; ++i) {
            ColorChannel channel = ColorChannel.values()[i];
            String exposureId = ExposureIdentifier.createId((class_1297)player, channel.method_15434());
            class_5321<ColorPalette> paletteKey = camera.mapAttachment(Attachment.FILM, FilmItem::getColorPaletteId).orElse(ColorPalettes.DEFAULT);
            class_6880<ColorPalette> colorPalette = ColorPalettes.get(((class_2168)context.getSource()).method_30497(), paletteKey);
            CaptureProperties captureProperties = new CaptureProperties.Builder(exposureId).setCameraHolder((CameraHolder)player).setCameraID(camera.getId().uuid().equals(class_156.field_25140) ? null : camera.getId()).setShutterSpeed(CameraSettings.SHUTTER_SPEED.getOrElse(camera, null)).setFilmType(ExposureType.BLACK_AND_WHITE).setFrameSize(camera.mapAttachment(Attachment.FILM, FilmItem::getFrameSize).orElse(null)).setCropFactor(camera.map((cameraItem, cameraStack) -> Float.valueOf(cameraItem.getCropFactor())).orElse(Float.valueOf(1.0f)).floatValue()).setColorPalette(colorPalette).setChromaticChannel(channel).build();
            properties.add(captureProperties);
            Frame frame = camera.map((cameraItem, cameraStack) -> {
                PointOfView pov = cameraItem.getPointOfView((CameraHolder)player, (class_1799)cameraStack);
                float fov = cameraItem.getViewfinderFov(player.method_37908(), (class_1799)cameraStack);
                List<class_2338> positions = cameraItem.getPositionsInFrame((CameraHolder)player, pov, fov);
                List<class_1309> entities = EntitiesInFrame.get((CameraHolder)player, pov, (double)fov);
                return cameraItem.createFrame((CameraHolder)player, ((class_2168)context.getSource()).method_9225(), (class_1799)cameraStack, captureProperties, positions, entities);
            }).orElse(Frame.create().setIdentifier(ExposureIdentifier.id(exposureId)).setType(ExposureType.BLACK_AND_WHITE).setPhotographer(new Photographer((CameraHolder)player)).toImmutable());
            Supplier<class_2561> msg = () -> {
                @Nullable class_1799 photograph = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
                photograph.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
                return class_2561.method_43470((String)("Captured " + channel.method_15434() + " channel exposure: ")).method_10852((class_2561)class_2561.method_43470((String)exposureId).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/exposure show id " + exposureId)).method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(photograph))).method_30938(Boolean.valueOf(true))));
            };
            ExposureServer.exposureRepository().expect(player, exposureId, (pl, id) -> ((class_2168)context.getSource()).method_9226(msg, true));
            ExposureServer.frameHistory().add((class_1297)player, frame);
        }
        Packets.sendToClient(new CaptureStartDebugRGBS2CP(CaptureType.DEBUG_RGB, properties), player);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Capturing RGB channels..."), true);
        return 0;
    }

    private static int chromaticFromLastThreeExposures(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 stack = (class_2168)context.getSource();
        class_3222 player = stack.method_9207();
        List<Frame> allFrames = ExposureServer.frameHistory().getFramesOf((class_1297)player).stream().filter(frame -> !frame.isChromatic()).toList();
        ArrayList<Frame> frames = new ArrayList<Frame>(allFrames.subList(Math.max(allFrames.size() - 3, 0), allFrames.size()));
        if (frames.size() < 3) {
            stack.method_9213((class_2561)class_2561.method_43470((String)"Not enough frames captured. 3 is required."));
            return 1;
        }
        try {
            Frame frame22;
            ChromaticSheetItem item = Exposure.Items.CHROMATIC_SHEET.get();
            class_1799 itemStack = new class_1799((class_1935)item);
            for (Frame frame22 : frames) {
                item.addLayer(itemStack, frame22);
            }
            class_1799 photographStack = item.combineIntoPhotograph(player, itemStack, false);
            frame22 = (Frame)photographStack.method_57824(Exposure.DataComponents.PHOTOGRAPH_FRAME);
            Preconditions.checkState((frame22 != null ? 1 : 0) != 0, (Object)"Frame data cannot be empty after combining.");
            ExposureServer.frameHistory().add((class_1297)player, frame22);
            Supplier<class_2561> msg = () -> {
                String exposureId = frame22.identifier().getId().orElseThrow();
                return class_2561.method_43470((String)"Created chromatic exposure: ").method_10852((class_2561)class_2561.method_43470((String)exposureId).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/exposure show latest")).method_10949(new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(photographStack))).method_30938(Boolean.valueOf(true))));
            };
            stack.method_9226(msg, true);
        }
        catch (Exception e) {
            stack.method_9213((class_2561)class_2561.method_43470((String)("Failed to create chromatic exposure: " + String.valueOf(e))));
            return 1;
        }
        return 0;
    }

    private static int developFilmInHand(CommandContext<class_2168> context, boolean replace) throws CommandSyntaxException {
        class_2168 stack = (class_2168)context.getSource();
        class_3222 player = stack.method_9207();
        for (class_1268 hand : class_1268.values()) {
            class_1799 itemInHand = player.method_5998(hand);
            class_1792 class_17922 = itemInHand.method_7909();
            if (!(class_17922 instanceof FilmRollItem)) continue;
            FilmRollItem filmRollItem = (FilmRollItem)class_17922;
            DevelopedFilmItem itemType = filmRollItem.getType() == ExposureType.COLOR ? Exposure.Items.DEVELOPED_COLOR_FILM.get() : Exposure.Items.DEVELOPED_BLACK_AND_WHITE_FILM.get();
            class_1799 developedFilmStack = itemInHand.method_60503((class_1935)itemType);
            if (replace) {
                player.method_6122(hand, developedFilmStack);
            } else if (!player.method_7270(developedFilmStack)) {
                player.method_7329(developedFilmStack, true, false);
            }
            stack.method_9226(() -> class_2561.method_43469((String)"command.exposure.debug.develop.success", (Object[])new Object[]{itemInHand.method_7954()}), true);
            return 0;
        }
        stack.method_9213((class_2561)class_2561.method_43471((String)"command.exposure.debug.develop.fail.wrong_item"));
        return 1;
    }
}

